<?php

namespace App\Database;

use Illuminate\Database\Eloquent\Model;

class Factory extends Model 
{

    protected $table = 'factories';
    public $timestamps = true;
    protected $fillable = array('isIsland', 'project_name', 'continent_id', 'country_id', 'state_id', 'city_id', 'rated_power', 'energy_capacity', 'discharge_duration', 'status_id', 'revenue_id', 'connection_point_id', 'annoncement_date', 'paired_grid_resource', 'commissioning_date', 'research_institution_id', 'off_taker_id', 'funding_source_id', 'decsription', 'verified', 'verification_description', 'expected_commissioning_date', 'company_id', 'enery_storage_technology', 'power_electronics_manufacturer', 'system_integrator', 'om_contractor', 'epc', 'developer', 'owner', 'hyperlink_1', 'hyperlink_2');

    public function continent()
    {
        return $this->hasOne('App\Database\Continent', 'continent_id');
    }

    public function country()
    {
        return $this->hasOne('App\Database\Country', 'country_id');
    }

    public function state()
    {
        return $this->hasOne('App\Database\State', 'state_id');
    }

    public function city()
    {
        return $this->hasOne('App\Database\City', 'city_id');
    }

    public function Technologies()
    {
        return $this->hasOne('App\Database\Technology', 'technology_id');
    }

    public function status()
    {
        return $this->hasOne('App\Database\Status', 'status_id');
    }

    public function revenues()
    {
        return $this->belongsToMany('App\Database\Revenue');
    }

    public function connection_point()
    {
        return $this->hasOne('App\Database\Connectionpoint', 'connection_point_id');
    }

    public function research_institution()
    {
        return $this->hasOne('App\Database\ResearchInstitution', 'research_institution_id');
    }

    public function off_taker()
    {
        return $this->hasOne('App\Database\OffTaker', 'off_taker_id');
    }

    public function funding_source()
    {
        return $this->hasOne('App\Database\FundingSource', 'funding_source_id');
    }

    public function applications()
    {
        return $this->belongsTo('App\Database\Application');
    }

    public function persone_verifications()
    {
        return $this->hasMany('App\Database\PersonVerification');
    }

    public function company()
    {
        return $this->hasOne('App\Database\Company', 'company_id');
    }

}